// src to try to reproduce problem with RooPoisson
// Ian Connelly
// 10 May 2012
#include <iostream>
#include "RooPoisson.h"
#include "RooRealVar.h"
#include "RooDataSet.h"
#include "RooArgSet.h"
#include "RooAbsReal.h"
using std::cout;
using std::endl;
using namespace RooFit;

int main(){
    
    //Declare objects
    RooPoisson* pdfPoisson;
    RooPoisson* pdfOtherPoisson;
    RooRealVar* meanVar;
    RooRealVar* meanOtherVar;
    RooRealVar* nHadrons;
    double mean = 8.0;
    double meanOther = 12.0;
    cout << "TESTT" << endl;
    
    //Initialise objects
    meanVar = new RooRealVar("meanVar","meanVar",mean);
    meanOtherVar = new RooRealVar("meanOtherVar", "meanOtherVar", meanOther);
    cout << "1" << endl;
    nHadrons = new RooRealVar("nHadrons","nHadrons",0,50);
    cout << "2" << endl;
    pdfPoisson = new RooPoisson("pdfPoisson","Poisson pdf", *nHadrons, *meanVar);
    cout << "3" << endl;
    pdfOtherPoisson = new RooPoisson("pdfOtherPoisson","Other Poisson pdf",*nHadrons, *meanOtherVar);
    cout << "TEST" << endl;
    //Generate single event
    RooDataSet* data = (RooDataSet*)pdfPoisson->generate(RooArgSet(*nHadrons),1);
    //Not really needed here
    /*
    RooArgSet* setNHad = (RooArgSet*)data->get(0);
    nHadrons = (RooRealVar*)setNHad->find(nHadrons->GetName());
    int generatedHadrons = static_cast<int>(nHadrons->getVal());
    */

    //Get NLL
    RooAbsReal* nllNHad;
    RooAbsReal* nllOtherNHad;
    nllNHad = pdfPoisson->createNLL(*data);
    nllOtherNHad = pdfOtherPoisson->createNLL(*data);
    
    cout << "====>NLL Values - from the generating Poisson : " << nllNHad->getVal() << " and from the comparison Poisson : " << nllOtherNHad->getVal() << endl;
    
    
    //Now loop a few times using setData()
    for(int i = 0; i < 10; i++){
        data = (RooDataSet*)pdfPoisson->generate(RooArgSet(*nHadrons),1);
        nllNHad->setData(*data, kFALSE);
        nllOtherNHad->setData(*data,kFALSE);
        cout << "====>NLL Values - from the generating Poisson : " << nllNHad->getVal() << " and from the comparison Poisson : " << nllOtherNHad->getVal() << endl;
    }
    
    
    
    return 0;
}
