# ALL LENGTHS MUST BE GIVEN IN MILLIMETRES
# ALL ROTATIONS MUST BE GIVEN IN RADIANS

DROP DATABASE IF EXISTS HCOL;
CREATE DATABASE HCOL;
USE HCOL;

CREATE TABLE HCOL_BOX (
    PARENTNAME    VARCHAR(32),  #
    POSX          DOUBLE(10,3), #
    POSY          DOUBLE(10,3), #
    POSZ          DOUBLE(10,3), #
    RED           DOUBLE(10,3), #
    GREEN         DOUBLE(10,3), #
    BLUE          DOUBLE(10,3), #
    VISATT        VARCHAR(32),  # I = INVISIBLE, S = SOLID, W = WIREFRAME
    LENGTHX       DOUBLE(10,3), #
    LENGTHY       DOUBLE(10,3), #
    LENGTHZ       DOUBLE(10,3), #
    ROTPSI        DOUBLE(10,3), #
    ROTTHETA      DOUBLE(10,3), #
    ROTPHI        DOUBLE(10,3), #
    SETSENSITIVE  INTEGER(16),  # TO ADD THE VOLUME TO THE LIST OF SENSITIVE COMPONENTS 
    MATERIAL      VARCHAR(32),  # MATERIAL, CGA LITERAL NAME
    NAME          VARCHAR(32),  # NAME OF SOLID, LOGICAL, AND PHYSICAL VOLUME
    INHERITSTYLE  VARCHAR(32)
);

INSERT INTO HCOL_BOX VALUES ("",0., 0., 0., 0., 0.5, 0.5, "S", 500, 500, 200, 0., 0.,0.,1,"TUNGSTEN", "HCOL_BULK","");

# incoming beamline hole
INSERT INTO HCOL_BOX VALUES ("HCOL_BULK",-170., 0., 0., 0., 0., 0., "S", 50, 50, 300, 0., 0.,0.,1,"TUNGSTEN", "HCOL_HOLE1","SUBTRACT");

# photon hole
#INSERT INTO HCOL_BOX VALUES ("HCOL_BULK",-175., 0., 0., 0., 0., 0., "S", 60, 60, 300, 0., 0.,0.,1,"TUNGSTEN", "HCOL_HOLE1","SUBTRACT");

# outgoing beampipe
INSERT INTO HCOL_BOX VALUES ("HCOL_BULK",0., 0., 0., 0., 0., 0., "S", 150, 150, 300, 0., 0.,0.,1,"TUNGSTEN", "HCOL_HOLE2","SUBTRACT");
