# ALL LENGTHS MUST BE GIVEN IN MILLIMETRES
# ALL ROTATIONS MUST BE GIVEN IN RADIANS

DROP DATABASE IF EXISTS SAMPLE;
CREATE DATABASE SAMPLE;
USE SAMPLE;

CREATE TABLE IR_SAMPLER (
    POSX          DOUBLE(10,3), #
    POSY          DOUBLE(10,3), #
    POSZ          DOUBLE(10,3), #
    RED           DOUBLE(10,3), #
    GREEN         DOUBLE(10,3), #
    BLUE          DOUBLE(10,3), #
    VISATT        VARCHAR(32),  # I = INVISIBLE, S = SOLID, W = WIREFRAME
    LENGTH        DOUBLE(10,3), #
    ROUTERSTART   DOUBLE(10,3), #
    ROUTEREND     DOUBLE(10,3), #
    ROTPSI        DOUBLE(10,3), #
    ROTTHETA      DOUBLE(10,3), #
    ROTPHI        DOUBLE(10,3), #
    MATERIAL      VARCHAR(32),  # MATERIAL, CGA LITERAL NAME
    NAME          VARCHAR(32)   # NAME OF SOLID, LOGICAL, AND PHYSICAL VOLUME
);
                      
# inner parallel part, next to IP
INSERT INTO IR_SAMPLER VALUES (100e-3, 0.0, 100, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (200e-3, 0.0, 200, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (300e-3, 0.0, 300, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (400e-3, 0.0, 400, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (500e-3, 0.0, 500, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (600e-3, 0.0, 600, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (700e-3, 0.0, 700, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (800e-3, 0.0, 800, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (900e-3, 0.0, 900, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (1000e-3, 0.0, 1000, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (1100e-3, 0.0, 1100, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (1200e-3, 0.0, 1200, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (1300e-3, 0.0, 1300, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (1400e-3, 0.0, 1400, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (1500e-3, 0.0, 1500, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (1600e-3, 0.0, 1600, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (1700e-3, 0.0, 1700, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (1800e-3, 0.0, 1800, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (1900e-3, 0.0, 1900, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (2000e-3, 0.0, 2000, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (2100e-3, 0.0, 2100, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (2200e-3, 0.0, 2200, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (2300e-3, 0.0, 2300, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (2400e-3, 0.0, 2400, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (2500e-3, 0.0, 2500, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (2600e-3, 0.0, 2600, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (2700e-3, 0.0, 2700, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (2800e-3, 0.0, 2800, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (2900e-3, 0.0, 2900, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (3000e-3, 0.0, 3000, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (3100e-3, 0.0, 3100, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (3200e-3, 0.0, 3200, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (3300e-3, 0.0, 3300, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (3400e-3, 0.0, 3400, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (3500e-3, 0.0, 3500, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (3600e-3, 0.0, 3600, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (3700e-3, 0.0, 3700, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (3800e-3, 0.0, 3800, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (3900e-3, 0.0, 3900, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (4000e-3, 0.0, 4000, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (4100e-3, 0.0, 4100, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (4200e-3, 0.0, 4200, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (4300e-3, 0.0, 4300, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (4400e-3, 0.0, 4400, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (4500e-3, 0.0, 4500, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (4600e-3, 0.0, 4600, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (4700e-3, 0.0, 4700, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (4800e-3, 0.0, 4800, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (4900e-3, 0.0, 4900, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (5000e-3, 0.0, 5000, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (5100e-3, 0.0, 5100, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (5200e-3, 0.0, 5200, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (5300e-3, 0.0, 5300, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (5400e-3, 0.0, 5400, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (5500e-3, 0.0, 5500, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (5600e-3, 0.0, 5600, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (5700e-3, 0.0, 5700, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (5800e-3, 0.0, 5800, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (5900e-3, 0.0, 5900, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (6000e-3, 0.0, 6000, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (6100e-3, 0.0, 6100, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (6200e-3, 0.0, 6200, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (6300e-3, 0.0, 6300, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (6400e-3, 0.0, 6400, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (6500e-3, 0.0, 6500, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (6600e-3, 0.0, 6600, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (6700e-3, 0.0, 6700, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (6800e-3, 0.0, 6800, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (6900e-3, 0.0, 6900, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (7000e-3, 0.0, 7000, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (7100e-3, 0.0, 7100, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (7200e-3, 0.0, 7200, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (7300e-3, 0.0, 7300, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (7400e-3, 0.0, 7400, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (7500e-3, 0.0, 7500, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (7600e-3, 0.0, 7600, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (7700e-3, 0.0, 7700, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (7800e-3, 0.0, 7800, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (7900e-3, 0.0, 7900, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (8000e-3, 0.0, 8000, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (8100e-3, 0.0, 8100, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (8200e-3, 0.0, 8200, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (8300e-3, 0.0, 8300, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (8400e-3, 0.0, 8400, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (8500e-3, 0.0, 8500, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (8600e-3, 0.0, 8600, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (8700e-3, 0.0, 8700, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (8800e-3, 0.0, 8800, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (8900e-3, 0.0, 8900, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 
INSERT INTO IR_SAMPLER VALUES (9000e-3, 0.0, 9000, 1.0, 1.0, 1.0, "S", 1e-8, 335, 335, 0., 0., 1e-3, "VACUUM", ""); 

