# ALL LENGTHS MUST BE GIVEN IN MILLIMETRES
# ALL ROTATIONS MUST BE GIVEN IN RADIANS


CREATE TABLE MASK_CONE (
    PARENTNAME    VARCHAR(32),  #
    POSX          DOUBLE(10,3), #
    POSY          DOUBLE(10,3), #
    POSZ          DOUBLE(10,3), #
    RED           DOUBLE(10,3), #
    GREEN         DOUBLE(10,3), #
    BLUE          DOUBLE(10,3), #
    VISATT        VARCHAR(32),  # I = INVISIBLE, S = SOLID, W = WIREFRAME
    LENGTH        DOUBLE(10,3), #
    RINNERSTART   DOUBLE(10,3), #
    RINNEREND     DOUBLE(10,3), #
    ROUTERSTART   DOUBLE(10,3), #
    ROUTEREND     DOUBLE(10,3), #
    ROTPSI        DOUBLE(10,3), #
    ROTTHETA      DOUBLE(10,3), #
    ROTPHI        DOUBLE(10,3), #
    MATERIAL      VARCHAR(32),  # MATERIAL, CGA LITERAL NAME
    NAME          VARCHAR(32),   # NAME OF SOLID, LOGICAL, AND PHYSICAL VOLUME
    INHERITSTYLE  VARCHAR(32)   # NAME OF SOLID, LOGICAL, AND PHYSICAL VOLUME
);

INSERT INTO MASK_CONE VALUES ("", 0, 0.0, 0, 1.0, 0.0, 0.0, "S", 300, 0, 0, 400., 400., 0.,  0.00, 0, "ALUMINIUM", "BULK", ""); 

INSERT INTO MASK_CONE VALUES ("BULK", 100., 0.0, 0, 0.0, 0.0, 0.0, "I", 400, 0., 0., 50., 50., 0.,  0.00, 0, "VACUUM", "HOLE1", "SUBTRACT"); 


INSERT INTO MASK_CONE VALUES ("BULK", 0., 0.0, 0, 0.0, 0.0, 0.0, "I", 400, 0., 0., 50., 50., 0.,  0.00, 0, "VACUUM", "HOLE2", "SUBTRACT"); 

# Outer Iron of Magnet - 2mrad
#INSERT INTO INVQD0_CONE VALUES ("", 5.750, 0.0, 6245, 1.0, 0.0, 0.0, "S", 2500, 35.0, 35.0, 250.0, 250.0, 0.,  0.00, -1e-3, 0.0, "QUAD", "Iron", "QD0_OUTER"); 

