# ALL LENGTHS MUST BE GIVEN IN MILLIMETRES
# ALL ROTATIONS MUST BE GIVEN IN RADIANS



DROP DATABASE IF EXISTS CRYO2;
CREATE DATABASE CRYO2;
USE CRYO2;




CREATE TABLE TUBE_CONE (
		PARENTNAME		VARCHAR(32),  #
    POSX          DOUBLE(10,3), #
    POSY          DOUBLE(10,3), #
    POSZ          DOUBLE(10,3), #
    RED           DOUBLE(10,3), #
    GREEN         DOUBLE(10,3), #
    BLUE          DOUBLE(10,3), #
    VISATT        VARCHAR(32),  # I = INVISIBLE, S = SOLID, W = WIREFRAME
    LENGTH        DOUBLE(10,3), #
    RINNERSTART   DOUBLE(10,3), #
    RINNEREND     DOUBLE(10,3), #
    ROUTERSTART   DOUBLE(10,3), #
    ROUTEREND     DOUBLE(10,3), #
    ROTPSI        DOUBLE(10,3), #
    ROTTHETA      DOUBLE(10,3), #
    ROTPHI        DOUBLE(10,3), #
    MATERIAL      VARCHAR(32),  # MATERIAL, CGA LITERAL NAME
  NAME          VARCHAR(32)   # NAME OF SOLID, LOGICAL, AND PHYSICAL VOLUME
);





CREATE TABLE ablock_box (
		PARENTNAME		VARCHAR(32),
    PosX          DOUBLE(10,3), #
    PosY          DOUBLE(10,3), #
    PosZ          DOUBLE(10,3), #
    Red           DOUBLE(10,3), #
    Blue          DOUBLE(10,3), #
    Green         DOUBLE(10,3), #
    VisAtt        VARCHAR(32),  # i = invis, s = solid, w = wireframe
    LengthX       DOUBLE(10,3), #
    LengthY       DOUBLE(10,3), #
    LengthZ       DOUBLE(10,3), #
    Material      VARCHAR(32),  # material, CGA literal name
    Name          VARCHAR(32)   # name of solid, logical, and physical volume
);
CREATE TABLE cavity_POLYCONE (
		PARENTNAME		VARCHAR(32),  #
    POSX          DOUBLE(10,3), #
    POSY          DOUBLE(10,3), #
    POSZ          DOUBLE(10,3), #
    RED           DOUBLE(10,3), #
    GREEN         DOUBLE(10,3), #
    BLUE          DOUBLE(10,3), #
    VISATT        VARCHAR(32),  # I = INVISIBLE, S = SOLID, W = WIREFRAME
    NZPLANES      INTEGER(16),  #

PLANEPOS1 DOUBLE(10,3), #
PLANEPOS2 DOUBLE(10,3), #
PLANEPOS3 DOUBLE(10,3), #
PLANEPOS4 DOUBLE(10,3), #
PLANEPOS5 DOUBLE(10,3), #
PLANEPOS6 DOUBLE(10,3), #
PLANEPOS7 DOUBLE(10,3), #
PLANEPOS8 DOUBLE(10,3), #
PLANEPOS9 DOUBLE(10,3), #
PLANEPOS10 DOUBLE(10,3), #
PLANEPOS11 DOUBLE(10,3), #
PLANEPOS12 DOUBLE(10,3), #
PLANEPOS13 DOUBLE(10,3), #
PLANEPOS14 DOUBLE(10,3), #
PLANEPOS15 DOUBLE(10,3), #
PLANEPOS16 DOUBLE(10,3), #
PLANEPOS17 DOUBLE(10,3), #
PLANEPOS18 DOUBLE(10,3), #
PLANEPOS19 DOUBLE(10,3), #
PLANEPOS20 DOUBLE(10,3), #
PLANEPOS21 DOUBLE(10,3), #
PLANEPOS22 DOUBLE(10,3), #
PLANEPOS23 DOUBLE(10,3), #

RINNER1 DOUBLE(10,3), #
RINNER2 DOUBLE(10,3), #
RINNER3 DOUBLE(10,3), #
RINNER4 DOUBLE(10,3), #
RINNER5 DOUBLE(10,3), #
RINNER6 DOUBLE(10,3), #
RINNER7 DOUBLE(10,3), #
RINNER8 DOUBLE(10,3), #
RINNER9 DOUBLE(10,3), #
RINNER10 DOUBLE(10,3), #
RINNER11 DOUBLE(10,3), #
RINNER12 DOUBLE(10,3), #
RINNER13 DOUBLE(10,3), #
RINNER14 DOUBLE(10,3), #
RINNER15 DOUBLE(10,3), #
RINNER16 DOUBLE(10,3), #
RINNER17 DOUBLE(10,3), #
RINNER18 DOUBLE(10,3), #
RINNER19 DOUBLE(10,3), #
RINNER20 DOUBLE(10,3), #
RINNER21 DOUBLE(10,3), #
RINNER22 DOUBLE(10,3), #
RINNER23 DOUBLE(10,3), #

ROUTER1 DOUBLE(10,3), #
ROUTER2 DOUBLE(10,3), #
ROUTER3 DOUBLE(10,3), #
ROUTER4 DOUBLE(10,3), #
ROUTER5 DOUBLE(10,3), #
ROUTER6 DOUBLE(10,3), #
ROUTER7 DOUBLE(10,3), #
ROUTER8 DOUBLE(10,3), #
ROUTER9 DOUBLE(10,3), #
ROUTER10 DOUBLE(10,3), #
ROUTER11 DOUBLE(10,3), #
ROUTER12 DOUBLE(10,3), #
ROUTER13 DOUBLE(10,3), #
ROUTER14 DOUBLE(10,3), #
ROUTER15 DOUBLE(10,3), #
ROUTER16 DOUBLE(10,3), #
ROUTER17 DOUBLE(10,3), #
ROUTER18 DOUBLE(10,3), #
ROUTER19 DOUBLE(10,3), #
ROUTER20 DOUBLE(10,3), #
ROUTER21 DOUBLE(10,3), #
ROUTER22 DOUBLE(10,3), #
ROUTER23 DOUBLE(10,3), #


  

    ROTPSI        DOUBLE(10,3), #
    ROTTHETA      DOUBLE(10,3), #
    ROTPHI        DOUBLE(10,3), #
    MATERIAL      VARCHAR(32),  # MATERIAL, CGA LITERAL NAME
    NAME          VARCHAR(32)   # NAME OF SOLID, LOGICAL, AND PHYSICAL VOLUME
);



INSERT INTO TUBE_CONE VALUES ("",0.0, 265.0, 6239.2, 1.0, 0.5, 0.1, "w", 12478.4, 460.0, 460.0, 500.0, 500.0, 0., 0., 0., "CarbonSteel", "vessel_shell"); 
                         
INSERT INTO ablock_box VALUES ("vessel_shell",0.0, 355.0, 0.0, 0.0, 0.0, 1.0, "s", 420, 6, 12478.4, "Aluminium", "upper_heat_shield"); 

INSERT INTO ablock_box VALUES ("vessel_shell", 0.0, 305.0, 0.0, 0.0, 0.0, 1.0, "s", 470, 6, 12478.4, "Aluminium", "lower_heat_shield"); 


INSERT INTO ablock_box VALUES ("",0.0, 765.0, 6239.2, 1.0, 0.5, 0.1, "s", 270.0, 155.0, 270.0, "CarbonSteel", "support1a");

INSERT INTO ablock_box VALUES ("",0.0, 765.0, 10439.2, 1.0, 0.5, 0.1, "s", 270.0, 155.0, 270.0, "CarbonSteel", "support2a");

INSERT INTO ablock_box VALUES ("",0.0, 765.0, 2039.2, 1.0, 0.5, 0.1, "s", 270.0, 155.0, 270.0, "CarbonSteel", "support3a");

#INSERT INTO ablock_box VALUES ("",0.0, 765.0, 6239.2, 1.0, 0.5, 0.1, "s", 270.0, 155.0, 270.0, "CarbonSteel", "support1a");

#INSERT INTO ablock_box VALUES ("",0.0, 765.0, 6239.2, 1.0, 0.5, 0.1, "s", 270.0, 155.0, 270.0, "CarbonSteel", "support1a");

#INSERT INTO ablock_box VALUES ("",0.0, 765.0, 6239.2, 1.0, 0.5, 0.1, "s", 270.0, 155.0, 270.0, "CarbonSteel", "support1a");

#INSERT INTO ablock_box VALUES ("",0.0, 765.0, 6239.2, 1.0, 0.5, 0.1, "s", 270.0, 155.0, 270.0, "CarbonSteel", "support1a");

#INSERT INTO ablock_box VALUES ("",0.0, 765.0, 6239.2, 1.0, 0.5, 0.1, "s", 270.0, 155.0, 270.0, "CarbonSteel", "support1a");

#INSERT INTO ablock_box VALUES ("",0.0, 765.0, 6239.2, 1.0, 0.5, 0.1, "s", 270.0, 155.0, 270.0, "CarbonSteel", "support1a");

#INSERT INTO ablock_box VALUES ("",0.0, 765.0, 6239.2, 1.0, 0.5, 0.1, "s", 270.0, 155.0, 270.0, "CarbonSteel", "support1a");

#INSERT INTO ablock_box VALUES ("",0.0, 765.0, 6239.2, 1.0, 0.5, 0.1, "s", 270.0, 155.0, 270.0, "CarbonSteel", "support1a");


INSERT INTO TUBE_CONE VALUES ("vessel_shell",0.0, -105., 0., 0.0, 0.0, 1.0, "S", 12478.4, 0.0, 0.0, 6.0, 6.0, 0., 0., 0., "Invar", "invar_rod"); 

INSERT INTO TUBE_CONE VALUES ("vessel_shell", 0.0, 105, 0.0, 100, 0.0, 1.0, "S", 12478.4, 150.0, 150.0, 156.0, 156.0, 0., 0., 0., "Aluminium", "2K_return_pipe"); 

INSERT INTO TUBE_CONE VALUES ("2K_return_pipe", 0.0, 0.0, 0.0, 0.3, 0.12, 0.5, "S", 12478.4, 0.0, 0.0, 149.999, 149.999, 0., 0., 0., "LiquidHelium", "He_in_2K_ret_pipe"); 

INSERT INTO TUBE_CONE VALUES ("vessel_shell", 0.0, -265.0, 0.0, 0.3, 0.12, 0.5, "w", 12478.4, 115.0, 115.0, 125.0, 125.0, 0.0, 0.0, 0.0, "Titanium", "pipe_around_cavity"); 


#INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0, 0.0, 1.0, 0.0, 0.0, "S", 23,

#0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

#35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

#38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

	#					     0.0, 0.0, 0.0, "Niobium", ""); 
INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-5783.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-5670.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity1");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-5558.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity2");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-5446.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity3");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-5334.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity4");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-5222.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity5");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-5109.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity6");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-4997.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity7");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-4885.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity8");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-4443.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity9");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-4331.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity10");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-4218.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity11");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-4106.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity12");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-3994.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity13");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-3882.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity14");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-3770.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity15");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-3657.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity16");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-3545.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity17");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-3103.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity18");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-2991.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity19");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-2879.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity20");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-2766.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity21");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-2654.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity22");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-2542.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity23");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-2430.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity24");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-2318.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity25");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-2205.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity26");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-1763.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity27");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-1651.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity28");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-1539.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity29");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-1427.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity30");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-1314.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity31");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-1202.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity32");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-1090.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity33");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-978.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity34");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,-866.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity35");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,866.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity36");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,978.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity37");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,1090.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity38");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,1202.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity39");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,1314.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity40");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,1427.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity41");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,1539.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity42");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,1651.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity43");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,1763.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity44");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,2205.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity45");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,2318.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity46");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,2430.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity47");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,2542.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity48");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,2654.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity49");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,2766.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity50");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,2879.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity51");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,2991.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity52");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,3103.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity53");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,3545.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity54");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,3657.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity55");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,3770.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity56");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,3882.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity57");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,3994.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity58");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,4106.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity59");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,4218.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity60");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,4331.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity61");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,4443.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity62");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,4885.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity63");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,4997.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity64");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,5109.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity65");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,5222.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity66");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,5334.3,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity67");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,5446.5,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity68");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,5558.7,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity69");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,5670.9,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity70");

INSERT INTO cavity_POLYCONE VALUES ("pipe_around_cavity",0.0, 0.0,5783.1,1.0, 0.0, 0.0, "S", 23,

0, 5.1, 10.2, 15.3, 20.4, 25.5, 30.6, 35.7, 40.8, 45.9, 51, 56.1, 61.2, 66.3, 71.4, 76.5, 81.6, 86.7, 91.8, 96.9, 102, 107.1, 112.2,

35.4259, 36.8004, 44.3601, 64.9776, 80.7844, 88.6877, 93.8421, 97.2784, 100.027, 101.745, 102.776, 103.464, 103.12, 102.433, 101.402, 99.3401, 96.2475, 92.124, 86.626, 77.3481, 57.7615, 40.5802, 36.1131,

38.2259, 40.2302, 53.0312, 77.1884, 86.8465, 92.8746, 97.4428, 100.553, 103.048, 104.602, 105.633, 106.278, 105.934, 105.289, 104.328, 102.477, 99.6774, 96.105, 91.4774, 84.9567, 69.9722, 46.1465, 39.1333,

0.0, 0.0, 0.0, "Niobium", "cavity71");



