# ALL LENGTHS MUST BE GIVEN IN MILLIMETRES
# ALL ROTATIONS MUST BE GIVEN IN RADIANS

DROP DATABASE IF EXISTS TORUSTEST;
CREATE DATABASE TORUSTEST;
USE TORUSTEST;

CREATE TABLE MYTEST_BOX (
    PARENTNAME    VARCHAR(32), #
    POSX          DOUBLE(10,3), #
    POSY          DOUBLE(10,3), #
    POSZ          DOUBLE(10,3), #
    RED           DOUBLE(10,3), #
    GREEN         DOUBLE(10,3), #
    BLUE          DOUBLE(10,3), #
    VISATT        VARCHAR(32),  # I = INVISIBLE, S = SOLID, W = WIREFRAME
    LENGTHX       DOUBLE(10,3), #
    LENGTHY       DOUBLE(10,3), #
    LENGTHZ       DOUBLE(10,3), #
    ROTPSI        DOUBLE(10,3), #
    ROTTHETA      DOUBLE(10,3), #
    ROTPHI        DOUBLE(10,3), #
    MATERIAL      VARCHAR(32),  # MATERIAL, CGA LITERAL NAME
    NAME          VARCHAR(32)   # NAME OF SOLID, LOGICAL, AND PHYSICAL VOLUME
);

INSERT INTO MYTEST_BOX VALUES ("", 0., 0., 750, 0., 0., 1.0, "S", 200, 400, 300, 0., 0.0, 0, "LEAD", "A_BOX");

CREATE TABLE TORUSTEST_TORUS (
    PARENTNAME    VARCHAR(32), #
    POSX          DOUBLE(10,3), #
    POSY          DOUBLE(10,3), #
    POSZ          DOUBLE(10,3), #
    RED           DOUBLE(10,3), #
    GREEN         DOUBLE(10,3), #
    BLUE          DOUBLE(10,3), #
    VISATT        VARCHAR(32),  # I = INVISIBLE, S = SOLID, W = WIREFRAME
    RINNER        DOUBLE(10,3), #
    ROUTER        DOUBLE(10,3), #
    RSWEPT        DOUBLE(10,3), #
    STARTPHI      DOUBLE(10,3), #
    DELTAPHI      DOUBLE(10,3), #
    ROTPSI        DOUBLE(10,3), #
    ROTTHETA      DOUBLE(10,3), #
    ROTPHI        DOUBLE(10,3), #
    MATERIAL      VARCHAR(32),  # MATERIAL, CGA LITERAL NAME
    NAME          VARCHAR(32)   # NAME OF SOLID, LOGICAL, AND PHYSICAL VOLUME
);

#INSERT INTO TORUSTEST_TORUS VALUES ("A_BOX", 0., 0., 500, 0., 0., 1.0, "S", 20, 40, 300, 0, 0.7, 0., 1.57, 0, "LEAD", "A_TORUS");
INSERT INTO TORUSTEST_TORUS VALUES ("a_BoX", -300., 0., 0, 0., 0., 1.0, "S", 20, 40, 300, 0, 6.2, 0., 1.57, 0, "LEAD", "A_TORUS");


CREATE TABLE MYTEST_CONE (
    PARENTNAME    VARCHAR(32), #
    POSX          DOUBLE(10,3), #
    POSY          DOUBLE(10,3), #
    POSZ          DOUBLE(10,3), #
    RED           DOUBLE(10,3), #
    GREEN         DOUBLE(10,3), #
    BLUE          DOUBLE(10,3), #
    VISATT        VARCHAR(32),  # I = INVISIBLE, S = SOLID, W = WIREFRAME
    LENGTH        DOUBLE(10,3), #
    RINNERSTART   DOUBLE(10,3), #
    RINNEREND     DOUBLE(10,3), #
    ROUTERSTART   DOUBLE(10,3), #
    ROUTEREND     DOUBLE(10,3), #
    ROTPSI        DOUBLE(10,3), #
    ROTTHETA      DOUBLE(10,3), #
    ROTPHI        DOUBLE(10,3), #
    MATERIAL      VARCHAR(32),  # MATERIAL, CGA LITERAL NAME
    NAME          VARCHAR(32)   # NAME OF SOLID, LOGICAL, AND PHYSICAL VOLUME
);

INSERT INTO MYTEST_CONE VALUES ("", 300, 0, 250, 1, 0, 0, "S", 500, 20, 20, 40, 40, 0., 0., 0., "TUNGSTEN", "");
#INSERT INTO MYTEST_CONE VALUES ("", 68.3, 0, 884.5, 1, 0, 0, "S", 500, 20, 20, 40, 40, 0., 0., -0.7, "TUNGSTEN", "");


INSERT INTO MYTEST_CONE VALUES ("A_BOX", 0, 0, 0, 1, 0, 0, "S", 500, 20, 20, 40, 40, 0., 0., -0.7, "TUNGSTEN", "");

#INSERT INTO MYTEST_CONE VALUES ("", 68.3, 0, 884.5, 1, 0, 0, "S", 500, 20, 20, 40, 40, 0., 0., -0.7, "TUNGSTEN", "");
