/* BDSIM code.    Version 1.0
  
*/

#ifndef BDSRealisticCollimator_h
#define BDSRealisticCollimator_h 

#include"globals.hh"
#include"BDSAcceleratorComponent.hh"
#include "BDSMaterials.hh"
#include "G4LogicalVolume.hh"

#include "G4UserLimits.hh"
#include "G4VisAttributes.hh"
#include "G4Box.hh"
#include "G4EllipticalTube.hh"
#include "BDSEnergyCounterSD.hh"

#include "parser/gmad.h" // for type definitions


class BDSRealisticCollimator :public BDSAcceleratorComponent
{
public:
  BDSRealisticCollimator(G4String aName,G4double bpRad, 
	     G4double xAper, G4double yAper,G4int type,
	     G4double flatLength, G4double taperLength,
	     G4Material *collimatorMaterial, G4double outR);
  ~BDSRealisticCollimator();

protected:

private:
  void BuildInnerCollimator();
  G4VisAttributes* SetVisAttributes();

  // Geometrical objects:

  G4VPhysicalVolume* itsPhysiComp;
  G4VPhysicalVolume* itsPhysiComp2;
  G4LogicalVolume* itsSolidLogVol;
  G4LogicalVolume* itsInnerLogVol;
  G4LogicalVolume* itsAperLogVol;
  G4LogicalVolume* itsJaw1LogVol;
  G4LogicalVolume* itsJaw2LogVol;
                    
  G4UserLimits* itsUserLimits;
  G4VisAttributes* itsVisAttributes;
  G4Mag_UsualEqRhs* itsEqRhs;

private:
  G4Material* itsCollimatorMaterial;
  BDSEnergyCounterSD* itsEnergyCounterSD;
  G4double itsOuterR;
  G4double itsFlatLength;
  G4double itsTaperLength;
};

#endif
