/* BDSIM code.    Version 1.0
   Author: Grahame A. Blair, Royal Holloway, Univ. of London.
   Last modified 24.7.2007
   Copyright (c) 200 by G.A.Blair.  ALL RIGHTS RESERVED. 
*/ 
//      ------------ BDSMottProcess physics process --------
//                     modified from H.Burkhard by Grahame Blair, 11 Aug 2007 


#include "BDSGlobalConstants.hh" // must be first in include list
#include "BDSHTMottProcess.hh"
#include "G4ios.hh"
#include "G4UnitsTable.hh"

#include "BDSAcceleratorComponent.hh"

using namespace std;

extern G4int event_number;

typedef list<BDSAcceleratorComponent*>  BDSBeamline;
extern BDSBeamline theBeamline;


BDSHTMottProcess::BDSHTMottProcess():beta(1)
{} 

BDSHTMottProcess::BDSHTMottProcess(G4double BeamEnergy)
{
  G4double gamma=(BeamEnergy/MeV)/electron_mass_c2;
  beta=sqrt(1-1/(gamma*gamma));
  G4cout<<"beta="<<beta<<G4endl;
} 


BDSHTMottProcess::~BDSHTMottProcess(){
}


G4ThreeVector BDSHTMottProcess::GenerateScatteredElectron(G4double thetamin)
{    
  double z0 = 1./(1.-cos(thetamin));
  double ran,ratio,zinv,cosangmott;
  do
    {
      double ran = rand()/(double)RAND_MAX;

      double z1 = ran*(1./2. - z0) + z0;
      zinv = 1./z1;
      cosangmott = 1. - zinv;
      ratio = 1. - (beta*beta/2.)*(1.-cosangmott);
      ran = rand()/(double)RAND_MAX; 
    } while (ran>ratio); 

  ran = rand()/(double)RAND_MAX;
  double phi =twopi*(ran-0.5);
  double sinthetae = sqrt(2.*zinv -zinv*zinv);
  double costhetae = cosangmott;
  G4ThreeVector MomDir;

  MomDir.setX(sinthetae*cos(phi));
  MomDir.setY(sinthetae*sin(phi));
  MomDir.setZ(costhetae);
   
  return MomDir;
}


